'use strict';

function EndCreatorCtrl($scope, $rootScope, $http, $window){
    var elementId = "#modal-end-creator";

    $scope.errors = [];
    $scope.statesConfirmed = false;

    $scope.openModal = function(){
        var message = {
            title: 'Zakończenie kreatora'
            ,msg: 'Trwa sprawdzanie poprawności wprowadzonych danych. Proszę czekać...'
        }

        $rootScope.$broadcast('Message:addMsg', message);

        $http.get(appDev + '/front/rest/creator/end_creator')
            .success(function(data){
                $rootScope.$broadcast('Message:delMsg', message);

                $scope.statesConfirmed = data.states_confirmed;
                $scope.errors = data.errors;

                angular.element(elementId).modal('show');
            })
            .error(function(data){

            })
        ;
    }

    $scope.closeModal = function(){
        angular.element(elementId).modal('hide');
    }



    $scope.endCreator = function(){
        $scope.closeModal();

        var message = {
            title: 'Zakończenie kreatora'
            ,msg: 'Trwa kończenie pracy kreatora. Proszę czekać...'
        }
        $rootScope.$broadcast('Message:addMsg', message);


        $http.post(appDev + '/front/rest/creator/end_creator')
            .success(function(data){
                $rootScope.$broadcast('Message:delMsg', message);

                $window.location = appDev + '/';

            })
            .error(function(data){

            })
        ;
    }
}

EndCreatorCtrl.$inject = ['$scope', '$rootScope', '$http', '$window'];